*change the directory to reflect your username and where the data is located in your computer

use "C:\Users\Goosephie\Desktop\GradQuant\Panel\IPUMSdata.dta"

drop if age<15

*The legal age of work in the US is 14. Drop all observations with age below 15.

drop if classwly<16

*Self employed workers should be dropped out of our estimation.

gen parttime=0

replace parttime=1 if uhrswork<35

*This is the dummy for part-time.

gen female=0

replace female=1 if sex==2

*Dummy for female.

gen ptimeandfemale=0

replace ptimeandfemale=parttime*female

*Dummy for interaction between female and part-time

tabulate statefip, generate(dummystate)

*Create state dummy variables

recode educ (2=0) (10=2.5) (20=5.5) (30=7.5) (40=9) (50=10) (60=11) (71=11.5) (73=12) (81=13) (91=14) (92=15) (111=16) (123=17.5) (124=19) (125=21)

*Transform educ into years of schooling.


gen single=0

replace single=1 if marst==6

gen marriedhusbandprsnt=0

replace marriedhusbandprsnt=1 if marst==1

gen marriedhusbandabsent=0

replace marriedhusbandabsent=1 if marst==2

gen separated=0

replace separated=1 if marst==3

gen divorced=0

replace divorced=1 if marst==4

gen widow=0

replace widow=1 if marst==5



**************************************************************

*Regressions/calculations

**************************************************************



*8. Run an ordinary least squares regression

*regression with control for state but not for industry

reg logwage parttime age agesquared educ female black single marriedhusbandabsent separated divorced widow i.statefip, robust


*9. Explain the coefficient on one of your state of residence control variables. 

* This regression command has Alabama as the benchmark state. We can see how being a California resident increases your hourly wage by 18,6%. 


*10. If you use sample weights

reg logwage parttime age agesquared educ female black single marriedhusbandabsent separated divorced widow i.statefip [iw=wtsupp]


*11. Now control for industry. How much of the part-time pay penalty is attributable to industry?

*regression controlling for industry

areg logwage parttime age agesquared educ female black single marriedhusbandabsent separated divorced widow i.statefip, absorb(indly)


* The part-time penalty was initially at 16.46%. Adding industry reduces 8.86% points, leaving a part-time penalty of about 6.8% . 


*12. Does the part-time pay penalty differ by gender? Explain the testing you did to arrive at your answer. 

areg logwage parttime age agesquared educ female black ptimeandfemale single marriedhusbandabsent separated divorced widow i.statefip, absorb(indly)

* Being part-time and female gives a slight positive advantage over men. This result counters the literature and is unexpected.
 
test _b[ptimeandfemale]=-0.5

test _b[ptimeandfemale]=0

test female parttime ptimeandfemale

test female ptimeandfemale


 


 
