install.packages("TAM")
library("TAM")
setwd("C:/Users/YaoYao/Desktop")
D1<-read.csv("D1_scored.csv")


#Item Parameter
M2<-tam.mml.2pl(D1)
ItemDiff2PL<-M2$item$AXsi_.Cat1
ItemDiff2PL
ItemDisc2PL<-M2$item$B.Cat1.Dim1
ItemDisc2PL
write.csv(M2$item,file="IRT2PL.csv")

# Theta
WLE2PL<-tam.mml.wle(M2)
Ability2PL<-WLE2PL$theta
write.csv(Ability2PL, file="Ability2PL.csv")

#Item fit plot
windows()
par(cex.axis=2,cex.lab=2,mar=(c(5,8,4,2)+0.1))
plot(M2)
tam.mml.fit(M2)#1 is best fit >1 underfit; <1 overfit #

#descriptive statistics of parameter
windows()
par(cex.axis=2,cex.lab=2,mar=(c(5,8,4,2)+0.1))
hist(ItemDiff2PL)
windows()
par(cex.axis=2,cex.lab=2,mar=(c(5,8,4,2)+0.1))
hist(Ability2PL)
mean(ItemDiff2PL)
mean(Ability2PL)
sd(ItemDiff2PL)
sd(Ability2PL)

#plotting parameters
windows()
par(mfrow=c(2,1),cex.axis=2,cex.lab=2,mar=(c(5,8,4,2)+0.1))
hist(ItemDiff2PL, xlim=c(-3,3),xlab=expression(ItemDiff),ylab="frequency")
hist(Ability2PL,xlim=c(-3,3),xlab=expression(theta),ylab="frequency")

# Comparison of summed score and theta
raw_score<-rowSums(D1)
raw_score<-data.matrix(raw_score)
head(raw_score)
Ability<-data.matrix(Ability2PL)
head(Ability,10)



