#-------------------------------------------------------------------------------------------------#
library(lavaan)                                                  # activate                       #
library(psych)                                                   # desired packages               #
#-------------------------------------------------------------------------------------------------#
#                                                                # set working directory          #
setwd('D:/MyStuff/cls/gradquant/example04_latentsem')               
#-------------------------------------------------------------------------------------------------#

qcmat  = as.matrix(read.table(file = 'quamme.cor.dat'))
print(qcmat)
qsdvec = as.matrix(read.table(file = 'quamme.sd.dat' ))
print(qsdvec)

qsdmat = diag(8)
diag(qsdmat) = qsdvec
print(qsdmat)

qcovs  =  qsdmat %*% qcmat %*% qsdmat
print(qcovs)

rownames(qcovs) = c('comadur','ageyrs','recal1','recal2','recog1','recog2','fluen1','fluen2')
colnames(qcovs) = c('comadur','ageyrs','recal1','recal2','recog1','recog2','fluen1','fluen2')
print(qcovs)

#-------------------------------------------------------------------------------------------------#
#  manifest   LV short  latent         
#  variable   name      variable            manifest variable definition
#
#  comadur    coma      coma                duration of coma (in hours) after heart attack
#  ageyrs     age       age                 age of patient (in years) at heart attack
#  recal1     recol     recollection        delayed recall memory for 15 words (3 months)
#  recal2     recol     recollection        delayed recall memory for 15 words (6 months)
#  recog1     famil     familiarity         recognition memory for 15 words (3 months)
#  recog2     famil     familiarity         recognition memory for 15 words (6 months)
#  fluen1     contr     controlled search   speedy production of words starting FAS (3 months)
#  fluen2     contr     controlled search   speedy production of words starting FAS (6 months)
#-------------------------------------------------------------------------------------------------#               

#-------------------------------------------------------------------------------------------------#
# Quamme model 1 general: single process model for recall and recognition
#    with parallel test contraints on factor loadings and unique variances
#-------------------------------------------------------------------------------------------------#

q.model1.gen = '
          # loadings of MVs on LVs in Lambda (L)  # lavaan code =~
            age    =~ NA*ageyrs 
            coma   =~ NA*comadur
            contr  =~ start(11.1)*L01*fluen1 + start(11.1)*L01*fluen2
            declr  =~ start(3.26)*L03*recal1 + start(3.26)*L03*recal2 + 
                      start(2.50)*L05*recog1 + start(2.50)*L05*recog2
            disru  =~ start(1.14)*L07*recal1 + start(1.14)*L07*recog1                             

          # intercepts of MVs in Nu (N)           # lavaan code ~
            # for now, this is a covariance structure model, so no means

          # unique vars & covs of MVs in Theta (T)# lavaan code ~~
            ageyrs ~~ 0*ageyrs     ;  comadur ~~ 0*comadur
            fluen1 ~~ T01*fluen1   ;  fluen2  ~~ T01*fluen2
            recal1 ~~ T03*recal1   ;  recal2  ~~ T03*recal2
            recog1 ~~ T05*recog1   ;  recog2  ~~ T05*recog2

          # means of LVs in Alpha (A)             # lavaan code ~
            # for now, this is a covariance structure model, so no means

          # vars & covariances of LVs in Psi (P)  # lavaan code ~~
            age   ~~ 1*age
            coma  ~~ 1*coma
            contr ~~ 0.963*contr
            declr ~~ 0.706*declr
            disru ~~ 1*disru

            coma  ~~ age;
            contr ~~ 0*age ; contr ~~ 0*coma ;
            declr ~~ 0*age ; declr ~~ 0*coma ; declr ~~ contr
            disru ~~ 0*age ; disru ~~ 0*coma ; disru ~~ 0*contr ; disru ~~ 0*declr

          # regressions among LVs in Beta (B)     # lavaan code ~
            contr ~  start(-.19)*age 
            declr ~  start(-.40)*age + start(-.40)*coma
            '

fit1 = lavaan(model = q.model1.gen, sample.cov = qcovs, sample.nobs = 56, model.type = "sem", 
              auto.fix.first = FALSE, auto.fix.single = FALSE)

summary(fit1, fit.measures = TRUE, standardized = TRUE)
inspect(fit1)
MI1 = modificationIndices(fit1)
subset(MI1, mi > 5)


#-------------------------------------------------------------------------------------------------#
# Quamme model 2 general: dual-process model for recall -- 
#    same as model 1 but ADD LOADINGS OF RECALL on CONTR
#    with parallel test contraints on factor loadings and unique variances
#-------------------------------------------------------------------------------------------------#

q.model2.gen = '
          # loadings of MVs on LVs in Lambda (L)  # lavaan code =~
            age    =~ start(11.6)*ageyrs 
            coma   =~ start(16.9)*comadur
            contr  =~ start(11.1)*L01*fluen1 + start(11.1)*L01*fluen2 +
                      start(-0.2)*L09*recal1 + start(-0.2)*L09*recal2
            declr  =~ start(3.26)*L03*recal1 + start(3.26)*L03*recal2 + 
                      start(2.50)*L05*recog1 + start(2.50)*L05*recog2
            disru  =~ start(1.14)*L07*recal1 + start(1.14)*L07*recog1                             

          # intercepts of MVs in Nu (N)           # lavaan code ~
            # for now, this is a covariance structure model, so no means

          # unique vars & covs of MVs in Theta (T)# lavaan code ~~
            ageyrs ~~ 0*ageyrs     ;  comadur ~~ 0*comadur
            fluen1 ~~ T01*fluen1   ;  fluen2  ~~ T01*fluen2
            recal1 ~~ T03*recal1   ;  recal2  ~~ T03*recal2
            recog1 ~~ T05*recog1   ;  recog2  ~~ T05*recog2

          # means of LVs in Alpha (A)             # lavaan code ~
            # for now, this is a covariance structure model, so no means

          # vars & covariances of LVs in Psi (P)  # lavaan code ~~
            age   ~~ 1*age
            coma  ~~ 1*coma
            contr ~~ 0.963*contr
            declr ~~ 0.706*declr
            disru ~~ 1*disru

            coma  ~~ age;
            contr ~~ 0*age ; contr ~~ 0*coma ;
            declr ~~ 0*age ; declr ~~ 0*coma ; declr ~~ contr
            disru ~~ 0*age ; disru ~~ 0*coma ; disru ~~ 0*contr ; disru ~~ 0*declr

          # regressions among LVs in Beta (B)     # lavaan code ~
            contr ~  start(-.19)*age 
            declr ~  start(-.40)*age + start(-.40)*coma
            '

fit2 = lavaan(model = q.model2.gen, sample.cov = qcovs, sample.nobs = 56, model.type = "sem", 
              auto.fix.first = FALSE, auto.fix.single = FALSE)

summary(fit2, fit.measures = TRUE, standardized = TRUE)
inspect(fit2)
MI2 = modificationIndices(fit2)
subset(MI2, mi > 5)


#-------------------------------------------------------------------------------------------------#
# Quamme model 3 general: dual-process model for recognition -- 
#    same as model 1 but ADD NEW LATENT VARIABLE FOR FAMILIARITY
#    with parallel test contraints on factor loadings and unique variances
#-------------------------------------------------------------------------------------------------#

q.model3.gen = '
          # loadings of MVs on LVs in Lambda (L)  # lavaan code =~
            age    =~ start(11.6)*ageyrs 
            coma   =~ start(16.9)*comadur
            contr  =~ start(11.1)*L01*fluen1 + start(11.1)*L01*fluen2 
            recol  =~ start(3.26)*L03*recal1 + start(3.26)*L03*recal2 + 
                      start(2.50)*L05*recog1 + start(2.50)*L05*recog2
            famil  =~ start(1.70)*L09*recog1 + start(1.70)*L09*recog2
            disru  =~ start(1.14)*L07*recal1 + start(1.14)*L07*recog1                             

          # intercepts of MVs in Nu (N)           # lavaan code ~
            # for now, this is a covariance structure model, so no means

          # unique vars & covs of MVs in Theta (T)# lavaan code ~~
            ageyrs ~~ 0*ageyrs     ;  comadur ~~ 0*comadur
            fluen1 ~~ T01*fluen1   ;  fluen2  ~~ T01*fluen2
            recal1 ~~ T03*recal1   ;  recal2  ~~ T03*recal2
            recog1 ~~ T05*recog1   ;  recog2  ~~ T05*recog2

          # means of LVs in Alpha (A)             # lavaan code ~
            # for now, this is a covariance structure model, so no means

          # vars & covariances of LVs in Psi (P)  # lavaan code ~~
            age   ~~ 1*age
            coma  ~~ 1*coma
            contr ~~ 0.963*contr
            recol ~~ 0.689*recol
            famil ~~ 1*famil
            disru ~~ 1*disru

            coma  ~~ age;
            contr ~~ 0*age ; contr ~~ 0*coma ;
            recol ~~ 0*age ; recol ~~ 0*coma ; recol ~~ contr
            famil ~~ 0*age ; famil ~~ 0*coma ; famil ~~ 0*contr ; famil ~~ 0*recol
            disru ~~ 0*age ; disru ~~ 0*coma ; disru ~~ 0*contr ; disru ~~ 0*recol ; disru ~~ 0*famil

          # regressions among LVs in Beta (B)     # lavaan code ~
            contr ~  start(-.19)*age 
            recol ~  start(-.40)*age + start(-.40)*coma
            '

fit3 = lavaan(model = q.model3.gen, sample.cov = qcovs, sample.nobs = 56, model.type = "sem", 
              auto.fix.first = FALSE, auto.fix.single = FALSE)

summary(fit3, fit.measures = TRUE, standardized = TRUE)
inspect(fit3)
MI3 = modificationIndices(fit3)
subset(MI3, mi > 5)


 