library(lavaan)
library(psych)

#-------------------------------------------------------------------------------------------------#
# reading a data set into R (data in ASCII format, with . for missing values)                     #
#   change element in na.strings statement to substitute a different missing value (e.g., -99)    #
#-------------------------------------------------------------------------------------------------#

hs39all = read.table(file = 'U:/MyStuff/cls/p205c/EXAMPLES/holzinger/r/hs39all_raw.txt',
                       na = '.')
#-------------------------------------------------------------------------------------------------#
# NOTE: I just read in the "raw-scored" version of the Holzinger-Swineford 1939 data              #
#-------------------------------------------------------------------------------------------------#
head(hs39all)
dim(hs39all)

names(hs39all) = c('case'    , 'school'  , 'grade'   , 'female'  , 'ageyr'  , 'mo'      , 'agemo', 
                   'visperc' , 'cubes'   , 'frmbord' , 'lozenges', 'geninfo', 'paracomp',
                   'sentcomp', 'wordclas', 'wordmean', 'addition', 'code'   , 'countdot', 
                   'sccaps'  , 'wordrecg', 'numbrecg', 'figrrecg', 'objnumb', 'numbfig' , 
                   'figword' , 'deducton', 'numbpuzz', 'probreas', 'series' , 'woody'   , 
                   'frmbord2', 'flags'   )
head(hs39all)

hs.model1 = '
            spatial  =~ visperc  + cubes    + lozenges
            verbal   =~ paracomp + sentcomp + wordmean
            speed    =~ addition + countdot + sccaps
            '

fit1 = cfa(hs.model1, data = hs39all)
summary(fit1, fit.measures = TRUE, standardized = TRUE)
inspect(fit1)


#-------------------------------------------------------------------------------------------------#
# using the HolzingerSwineford1939 data set "sitting around" when you invoke lavaan               #
#   to verify that you get the same results, even with rescaling of variables                     #
#-------------------------------------------------------------------------------------------------#
holz = HolzingerSwineford1939
dim(holz)

hs.model2 = '
            spatial  =~ x1  + x2  + x3
            verbal   =~ x4  + x5  + x6
            speed    =~ x7  + x8  + x9
            '

fit2 = cfa(hs.model2, data = holz)
summary(fit2, fit.measures = TRUE, standardized = TRUE)
inspect(fit2)


