#-------------------------------------------------------------------------------------------------#
library(lavaan)                                                  # activate                       #
library(psych)                                                   # desired packages               #
library(GPArotation)                                                                              #
#-------------------------------------------------------------------------------------------------#
#                                                                # set working directory          #
setwd('D:/MyStuff/cls/gradquant/example01_pathanalysis01')               
#-------------------------------------------------------------------------------------------------#

data = read.table(file = 'Kerchoff_Kenny.dat')

rownames(data) = c('int','dad_ed','dad_occ','grades','ed_exp','aspir')
colnames(data) = c('int','dad_ed','dad_occ','grades','ed_exp','aspir')
#-------------------------------------------------------------------------------------------------#
#  manifest variable       definition
#
#  dad_ed                  father's education level
#  dad_occ                 father's occupational status 
#  int                     son's intelligence
#  grades                  son's grade point average
#  ed_exp                  son's educational expectations
#  aspir                   son's occupational aspirations
#-------------------------------------------------------------------------------------------------#
data1 = as.matrix(data)
print(data1)

library(lavaan)

#-------------------------------------------------------------------------------------------------#
# Path Model #1: A priori hypothesized model
#-------------------------------------------------------------------------------------------------#
path1.lv = 'int    ~ dad_ed
            grades ~ dad_ed + int
            ed_exp ~ grades + int + dad_ed + dad_occ
            aspir  ~ grades + int + dad_occ + ed_exp
            
            dad_ed ~~ dad_ed
            dad_occ ~~ dad_occ
            int ~~ int
            grades ~~ grades
            ed_exp ~~ ed_exp
            aspir ~~ aspir
            
            dad_ed ~~ dad_occ'
          
fit.path1.lv = lavaan(model=path1.lv, sample.cov = data1, sample.nobs=767, fixed.x=FALSE)

summary             (fit.path1.lv, standardized=TRUE, fit.measures=TRUE, rsquare=TRUE)
parameterEstimates  (fit.path1.lv)
fitMeasures         (fit.path1.lv, fit.measures = "all")
modindices          (fit.path1.lv)
inspect             (fit.path1.lv)


#-------------------------------------------------------------------------------------------------#
# Path Model #2: Drop direct path from Intelligence to Occupational Aspirations
#-------------------------------------------------------------------------------------------------#
path2.lv = 'int    ~ dad_ed
            grades ~ dad_ed + int
            ed_exp ~ grades + int + dad_ed + dad_occ
            aspir  ~ grades + 0*int + dad_occ + ed_exp           # note path coeff fixed to 0
            
            dad_ed ~~ dad_ed
            dad_occ ~~ dad_occ
            int ~~ int
            grades ~~ grades
            ed_exp ~~ ed_exp
            aspir ~~ aspir
            
            dad_ed ~~ dad_occ'
          
fit.path2.lv = lavaan(model=path2.lv, sample.cov = data1, sample.nobs=767, fixed.x=FALSE)

summary             (fit.path2.lv, standardized=TRUE, fit.measures=TRUE, rsquare=TRUE)
parameterEstimates  (fit.path2.lv)
inspect             (fit.path2.lv)


#-------------------------------------------------------------------------------------------------#
# Path Model #3: Drop direct path from Father's SES to Occupational Aspirations
#-------------------------------------------------------------------------------------------------#
path3.lv = 'int    ~ dad_ed
            grades ~ dad_ed + int
            ed_exp ~ grades + int + dad_ed + dad_occ
            aspir  ~ grades + 0*int + 0*dad_occ + ed_exp           # note 2 path coeffs fixed to 0
            
            dad_ed ~~ dad_ed
            dad_occ ~~ dad_occ
            int ~~ int
            grades ~~ grades
            ed_exp ~~ ed_exp
            aspir ~~ aspir
            
            dad_ed ~~ dad_occ'
          
fit.path3.lv = lavaan(model=path3.lv, sample.cov = data1, sample.nobs=767, fixed.x=FALSE)

summary             (fit.path3.lv, standardized=TRUE, fit.measures=TRUE, rsquare=TRUE)
parameterEstimates  (fit.path3.lv)
inspect             (fit.path3.lv)


#-------------------------------------------------------------------------------------------------#
# Path Model #4: Test if Grades and Educ Expect. have Equal Effects on Occupational Aspriations
#-------------------------------------------------------------------------------------------------#
path4.lv = 'int    ~ dad_ed
            grades ~ dad_ed + int
            ed_exp ~ grades + int + dad_ed + dad_occ
            aspir  ~ b1*grades + 0*int + 0*dad_occ + b1*ed_exp    # note 2 path coeffs fixed to 0          
                                                                  # equality constraint invoked
                                                                  #  using same "name" for coeff
            
            dad_ed ~~ dad_ed
            dad_occ ~~ dad_occ
            int ~~ int
            grades ~~ grades
            ed_exp ~~ ed_exp
            aspir ~~ aspir
            
            dad_ed ~~ dad_occ'
          
fit.path4.lv = lavaan(model=path4.lv, sample.cov = data1, sample.nobs=767, fixed.x=FALSE)

summary             (fit.path4.lv, standardized=TRUE, fit.measures=TRUE, rsquare=TRUE)
parameterEstimates  (fit.path4.lv)
inspect             (fit.path4.lv)



    




