import numpy
numpy.loadtxt('inflammation-01.csv', delimiter=',')
numpy.loadtxt?

data = numpy.loadtxt('inflammation-01.csv', delimiter=',')
data
data.shape
data.mean()

# average for each patient across all days
data.mean(axis=1).shape

data.mean(axis=0).shape

# Access a specific value
data[4, 9]

# Specific row
data[4, :]


# Find the minimum of the maximum inflammation across patients for patients 7 through 13 over days 9 through 10.
# Each row is a patient, each column is a day.
data[7:14, 9:11].max(axis=1).min()

numpy.min(numpy.max(data[7:14, 9:11], axis=1))


import matplotlib.pyplot as plt
plt.imshow(data)

plt.imshow?

plt.plot(data.mean(axis=0))

plt.plot(data.max(axis=0))

plt.plot(data.min(axis=0))

# Panel of plots
fig = plt.figure(figsize=(10,3))

ax1 = fig.add_subplot(1, 3, 1)
ax2 = fig.add_subplot(1, 3, 2)
ax3 = fig.add_subplot(1, 3, 3)

ax1.plot(data.mean(axis=0))
ax1.set_ylabel('average')

ax2.plot(data.max(axis=0))
ax2.set_ylabel('max')

ax3.plot(data.min(axis=0))
ax3.set_ylabel('min')

fig.tight_layout()

## Loops
word = 'bird'
print type(word)
print word[0]
print word[1]
print word[2]
print word[3]
word[::1]


for letter in word:
    print letter

word = 'supercallifragilisticexpialidocious'

for letter in word:
    print letter

# For loop that counts letters in a string
count = 0
for letter in word:
    count += 1

print count

len(word)

len(data)

## Lists
stuff = list()
stuff
stuff.append('marklar')
len(stuff)
stuff.append(2)
stuff
stuff.append(data)
stuff[-1] #Last item

for item in stuff:
    print item

# Analyzing at scale
import glob
print glob.glob('inflammation-*.csv')

filenames = glob.glob('inflammation*.csv')
filenames.sort()
filenames

for filename in filenames:
    print filename
    
    data = numpy.loadtxt(filename, delimiter=',')
    
    fig = plt.figure(figsize=(10,3))

    ax1 = fig.add_subplot(1, 3, 1)
    ax2 = fig.add_subplot(1, 3, 2)
    ax3 = fig.add_subplot(1, 3, 3)

    ax1.plot(data.mean(axis=0))
    ax1.set_ylabel('average')

    ax2.plot(data.max(axis=0))
    ax2.set_ylabel('max')

    ax3.plot(data.min(axis=0))
    ax3.set_ylabel('min')

    # improves the rendered formatting by resizing axes to
    # accommodate labels
    fig.tight_layout()
    
    # tells matplotlib to render plot NOW
    plt.show()

## Functions
len('bird')
len()

def smaller(somenumber, other_number=10):
    if somenumber < other_number:
        out = True
    else:
        out = False
        
    return out

smaller(157)
smaller(7)

smaller(7, other_number=5)

def smaller(somenumber, other_number=10):
    return somenumber < other_number

def fahr_to_kelvin(temp):
    return ((temp - 32)) * (5/9) + 273.15

fahr_to_kelvin(32)

fahr_to_kelvin(212)
# Both of the above functions are wrong
212 - 32
(212 - 32) * (5/9)
5/float(9.0)

def fahr_to_kelvin(temp):
    return ((temp - 32)) * (5/float(9)) + 273.15

fahr_to_kelvin(212)

# Function that converts kelvin_to_celsius

def kelvin_to_celsius(temp):
    return temp - 273.15

print "{:.4f}".format(kelvin_to_celsius(273))


# References
first, second = 'Grace', 'Hopper'
third, fourth = second, first
print(third, fourth)

# Slicing strings
element = 'oxygen'
print('first three characters:', element[0:3])
print('last three characters:', element[3:6])

# Tuples
left = 'L'
right = 'R'

temp = left
left = right
right = temp

# Both examples exchange the values of left and right
print(left, right)

## Documentation/Docstrings


## Errors

def some_function()
    msg = "hello, world!"
    print(msg)
     return msg

# 2 errors above

# Mixing tabs and spaces
def some_function():
    msg = "hello, world!"
    print(msg)
    return msg

# Variable name errors
print(a)
print(hello)
print('hello')